package main

import (
	"log/slog"

	"github.com/alecthomas/kong"
	"vnbr.de/track/internal/cmd"
	"vnbr.de/track/internal/config"
)

type app struct {
	Verbose int  `short:"v" type:"counter"`
	Version bool `long:"version"`

	UI     cmd.Tui    `cmd:"" default:"1" hidden:""`
	Status cmd.Status `cmd:""`
}

func main() {
	cli := app{}
	ctx := kong.Parse(
		&cli,
		kong.Description(`
Track, manage and publish worklogs from the CLI.
		`),
	)

	switch cli.Verbose {
	case 0:
		slog.SetLogLoggerLevel(slog.LevelWarn)
	case 1:
		slog.SetLogLoggerLevel(slog.LevelInfo)
	default:
		slog.SetLogLoggerLevel(slog.LevelDebug)
	}

	if cli.Version {
		c := cmd.Version{}
		c.Run()
		return
	}

	err := ctx.Run(cmd.Context{
		Config:  config.LoadConfig(),
		Verbose: cli.Verbose,
	})
	ctx.FatalIfErrorf(err)
}
