package widget

import (
	"fmt"

	tea "github.com/charmbracelet/bubbletea"
	"vnbr.de/track/internal/ticket"
)

type TicketSelect struct {
	tickets  []ticket.Ticket
	current int
}

func NewTicketSelect(v []ticket.Ticket) TicketSelect {
	return TicketSelect{v, 0}
}

func (m TicketSelect) Value() (ticket.Ticket, bool) {
	if len(m.tickets) > m.current {
		return m.tickets[m.current], true
	} else {
		return ticket.Ticket{}, false
	}
}

func (m TicketSelect) Init() tea.Cmd {
	return nil
}

func (m TicketSelect) Update(msg tea.Msg) (TicketSelect, tea.Cmd) {
	switch msg := msg.(type) {

	case tea.KeyMsg:
		switch msg.String() {

		case "up", "k":
			if m.current > 0 {
				m.current--
			}

		case "down", "j":
			if m.current+1 < len(m.tickets) {
				m.current++
			}

		}
	}

	return m, nil
}

func (m TicketSelect) View() string {
	var c string
	s := "Select a ticket:\n\n"

	for i, t := range m.tickets {
		if i == int(m.current) {
			c = ">"
		} else {
			c = " "
		}

		s += fmt.Sprintf("%s %s: %s\n", c, t.Key, t.Title)
	}

	return s
}
