package widget

import (
	"fmt"
	"strings"

	tea "github.com/charmbracelet/bubbletea"
)

type PromptMsg struct {
	Error error
	Input string
}

type Prompt struct {
	Prompt string
	Value  string

	Back tea.Model
}

func NewPrompt(p string, v string) Prompt {
	return Prompt{
		Prompt: p,
		Value:  v,
	}
}

func (m Prompt) Init() tea.Cmd {
	return nil
}

func (m Prompt) Update(msg tea.Msg) (tea.Model, tea.Cmd) {
	switch msg := msg.(type) {

	case tea.KeyMsg:
		switch msg.String() {

		case "esc":
			if m.Back != nil {
				return m.Back, func() tea.Msg {
					return PromptMsg{Cancelled, m.Value}
				}
			} else {
				return m, tea.Quit
			}

		case "enter":
			if m.Back != nil {
				return m.Back, func() tea.Msg {
					return PromptMsg{nil, m.Value}
				}
			} else {
				return m, tea.Quit
			}

		case "backspace":
			if m.Value != "" {
				m.Value = m.Value[:len(m.Value)-1]
			}

		case "delete":
			m.Value = ""

		case "alt+enter":
			m.Value += "\n"

		default:
			m.Value += string(msg.Runes)

		}
	}

	return m, nil
}

func (m Prompt) View() string {
	p := m.Prompt

	if p == "" {
		p = "Enter value"
	}

	v := strings.Join(strings.Split(m.Value, "\n"), "\n> ")
	s := fmt.Sprintf("\n%s:\n> %s\n\n", p, v)

	s += "Press 'alt+enter' for new line.\n"
	s += "Press 'esc' to abort.\n"
	s += "Press 'enter' to confirm.\n"

	return s
}
