package view

import (
	tea "github.com/charmbracelet/bubbletea"
	"vnbr.de/track/internal/config"
	"vnbr.de/track/internal/view/scene"
)

type App struct {
	config config.Config
	scene  tea.Model
}

func NewApp(config config.Config) App {
	return App{
		config: config,
		scene:  scene.NewTimer(config),
	}
}

func (v App) Init() tea.Cmd {
	return v.scene.Init()
}

func (m App) Update(msg tea.Msg) (tea.Model, tea.Cmd) {
	var c tea.Cmd
	m.scene, c = m.scene.Update(msg)

	switch msg := msg.(type) {
	case tea.KeyMsg:
		switch msg.String() {

		case "ctrl+c":
			return m, tea.Quit

		case "ctrl+z":
			return m, tea.Suspend

		}
	}

	return m, c
}

func (m App) View() string {
	return m.scene.View()
}
