package util

func Empty[v comparable](value v) bool {
	var zero v
	return value == zero
}

func FirstValue[v comparable](parts ...v) v {
	var last v

	for _, part := range parts {
		if !Empty(part) {
			return part
		} else {
			last = part
		}
	}

	return last
}

func When[v comparable](cond bool, yes, no v) v {
	if cond {
		return yes
	}
	return no
}
