package ticket

import (
	"sort"
	"strings"
)

type MemoryManager struct {
	tickets map[string]Ticket
}

func NewMemoryManager() MemoryManager {
	return MemoryManager{
		map[string]Ticket{},
	}
}

func (m *MemoryManager) Add(t Ticket) (Ticket, error) {
	m.tickets[t.Key] = t
	return t, nil
}

func (m *MemoryManager) Delete(t Ticket) error {
	delete(m.tickets, t.Key)
	return nil
}

func (m *MemoryManager) Get(key string) (Ticket, error) {
	if t, ok := m.tickets[key]; ok {
		return t, nil
	}

	return Ticket{}, NotFound
}

func (m *MemoryManager) Search(query string) ([]Ticket, error) {
	var tlist []Ticket
	var keys []string

	for _, t := range m.tickets {
		if query == "" || strings.Contains(t.Key, query) || strings.Contains(t.Title, query) {
			keys = append(keys, t.Key)
		}
	}

	sort.Strings(keys)
	for _, key := range keys {
		if t, ok := m.tickets[key]; ok {
			tlist = append(tlist, t)
		}
	}

	return tlist, nil
}

func (m *MemoryManager) WithExamples() {
	tlist := []Ticket{
		{"FOO-1", "Example A"},
		{"FOO-2", "Example B"},
		{"FOO-3", "Example C"},
	}

	for _, t := range tlist {
		m.tickets[t.Key] = t
	}
}
