package ticket

import "errors"

var NotFound = errors.New("Ticket not found")

type Manager interface {
	Get(key string) (Ticket, error)
	Search(query string) ([]Ticket, error)
}

type AppendManager interface {
	Manager

	// Persist a new ticket by providing the title. The ticket key will be
	// generated and cannot be set in advance.
	Add(title string) (Ticket, error)
}

type CreateManager interface {
	Manager

	// Persist a new ticket.
	Add(Ticket) (Ticket, error)
}

type DeleteManager interface {
	Manager
	Delete(Ticket) error
}
