package fs

import (
	"errors"
	"os"
	"path"
	"runtime"
)

func UserStateDir() (string, error) {
	var dir string

	switch runtime.GOOS {
	case "windows":
		return os.UserCacheDir()

	case "darwin", "ios":
		return os.UserCacheDir()

	case "plan9":
		return os.UserCacheDir()

	default: // Unix
		dir = os.Getenv("XDG_STATE_HOME")
		if dir == "" {
			dir = os.Getenv("HOME")
			if dir == "" {
				return "", errors.New("neither $XDG_STATE_HOME nor $HOME are defined")
			}
			dir += "/.local/state"
		} else if path.IsAbs(dir) {
			return "", errors.New("path in $XDG_STATE_HOME is relative")
		}
	}

	return dir, nil
}
