package cmd

import (
	"fmt"
	"os"
	"time"

	"vnbr.de/track/internal/timer"
)

type Status struct{}

func (c *Status) Run(ctx Context) error {
	tr := ctx.Config.InitTimerRepositoryOrQuit()
	ids, _ := tr.ListIds()

	var noDuration time.Duration
	var isRunning bool
	var count int
	var state string
	var title string
	var elapsed time.Duration

	for _, id := range ids {
		if t, err := tr.Get(id); err == nil {
			state = max(state, t.GetStateIcon())
			elapsed = elapsed + t.GetElapsed()
			if title == "" && t.GetElapsed() != noDuration {
				title = t.Ticket.Title
			}
			if t.State == timer.Running {
				isRunning = true
				count = count + 1
			}
		}
	}

	if title == "" {
		// no running timer. use title of last one.
		title = "No timer running"
	}

	if count > 1 {
		title += fmt.Sprintf(" (and %d more)", count-1)
	}

	fmt.Printf("[%s %s] %s\n", state, elapsed, title)

	if isRunning {
		os.Exit(0)
	} else if elapsed != noDuration {
		os.Exit(2) // stopped
	} else {
		os.Exit(1) // none running
	}

	return nil
}
